package jrand.parser;

import java.io.*;
import java.util.*;

public class CFGTokenizer {
	private Reader input;
	private BufferedReader br;
	private StringTokenizer st;
	public final static String tokens = "\t <>\"\\'";
	public final static boolean incTokens = true;
	private boolean nomore;
	private String holdback;
	private int lineno;

	public final static String startNode = "<";
	public final static String endNode = ">";

	public final static String startString = "\"";
	public final static String endString = "\"";

	public final static String startChar = "\'";
	public final static String endChar = "\'";

	public final static String or = "|";
	public final static String equals = "=";
	public final static String linefeed = "\n";
	public final static String carriagereturn = "\r";
	public final static String crlf = "\r\n";

	private CFGTokenizer() {}

	public CFGTokenizer(Reader boo) throws IOException {
		input = boo;
		nomore = false;
		holdback = null;

		br = new BufferedReader(input);

		String temp;
		temp = br.readLine();
		lineno = 1;
		st = new StringTokenizer(temp, tokens, incTokens);
	}

	public String nextElement() {
		if(holdback != null) {
			String moo = holdback;
			holdback = null;
			return moo;
		}

		String temp;
		boolean eol = false;
		
		if(nomore == true) return null;

		while(!st.hasMoreTokens()) {
			eol = true;
			try {
				temp = br.readLine();
			} catch (IOException e) {
				temp = null;
			}
			if(temp == null) {
				nomore = true;
				return null;
			}
			lineno++;
			st = new StringTokenizer(temp, tokens, incTokens);
		}

		if(eol) return "\n";

		temp = st.nextToken();
		if(temp.equals("\\")) {
			if(st.hasMoreTokens() == false) {
				//here we meet "\ \n", so we eat the slash,
				//eat the newline and later return the first token
				//of the next line.
				nextElement();
				return nextElement();
			} else {
				String temp2 = st.nextToken();
				char test = temp2.charAt(0);
				holdback = temp2.substring(1);
				if(holdback.length() < 1) holdback = null;

				switch(test) {
					case 't': return "\t";
					case 'n': return "\n";
					case 'b': return "\b";
					case 's': return "";

					//these 3 are bizarre.
					case '=': return "=";
					case '%': return "%";
					case '\\': return "\\";
					default:
						return "\\"+test;
				}
			}
		} else {
			return temp;
		}
	}

	public boolean hasMoreElements() {
		if(holdback != null) return true;
		return nomore == false;
	}

	public CFGToken nextToken() {
		String start;
		
		while(true) {
			start = nextElement();
			if(start == null) return null;
			if(start.equals(startNode)) {
				String name = nextElement();
				String end = nextElement();
				if(!end.equals(endNode)) {
					System.err.println("error! "+start+name+end+" is not a valid node name!");
				}
				return new CFGToken(CFGToken.NODE, name);
			} else if(start.equals(startString)) {
				StringBuffer sb = new StringBuffer();
				String next;
				
				//just keep collecting words until we hit the end.
				next = nextElement();
				while(next != null && !next.equals(endString)) {
					if(next.equals("\\\"")) {
						sb.append("\"");
					} else if(next.equals("\\<")) {
						sb.append("<");
					} else if(next.equals("\\>")) {
						sb.append(">");
					} else {
						sb.append(next);
					}
					next = nextElement();
				}
				
				if(!next.equals(endString)) {
					System.err.println("error! "+start+sb.toString()+next+" is not a valid string!");
				}
				return new CFGToken(CFGToken.STRING, sb.toString());
			} else if(start.equals(startChar)) {
				String body = nextElement();
				String end = nextElement();
				if(!end.equals(endChar) && end.length() > 1) {
					System.err.println("error! "+start+body+end+" is not a valid char!");
				}
				return new CFGToken(CFGToken.CHAR, body);
			} else if(start.equals(or)) {
				return new CFGToken(CFGToken.OR);
			} else if(start.equals(equals)) {
				return new CFGToken(CFGToken.EQUALS);
			} else if(start.equals(crlf) || start.equals(linefeed) || start.equals(carriagereturn)) {
				return new CFGToken(CFGToken.ENDRULE);
			}

		}

	}

	public boolean hasMoreTokens() {
		return hasMoreElements();
	}

	public int getLineNumber() {return lineno;}
}
