package jrand.event;

import java.util.EventListener;

/**
 * ListDataListener
 *
 * @version 1.7 09/21/98
 * @author Hans Muller
 */
public interface CFGListDataListener extends EventListener {

    /** 
     * Sent after the indices in the index0,index1 
     * interval have been inserted in the data model.
     * The new interval includes both index0 and index1.
     *
     * @param e  a CFGListDataEvent encapuslating the event information
     */
    void intervalAdded(CFGListDataEvent e);

    
    /**
     * Sent after the indices in the index0,index1 interval
     * have been removed from the data model.  The interval 
     * includes both index0 and index1.
     *
     * @param e  a CFGListDataEvent encapuslating the event information
     */
    void intervalRemoved(CFGListDataEvent e);


    /** 
     * Sent when the contents of the list has changed in a way 
     * that's too complex to characterize with the previous 
     * methods.  Index0 and index1 bracket the change.
     *
     * @param e  a CFGListDataEvent encapuslating the event information
     */
    void contentsChanged(CFGListDataEvent e);

    void rootChanged(CFGListDataEvent e);
}

