import java.io.*;
import java.util.*;

public class HumanOutputStream extends OutputStream implements Runnable {
	private PipedOutputStream out;
	private PipedInputStream in;

	private OutputStream lastout;
	private Thread runner;

	public HumanOutputStream(OutputStream lo) throws IOException {
		out = new PipedOutputStream();
		in = new PipedInputStream(out);

		lastout = lo;
		inWord = true;

		runner = new Thread(this);
		runner.start();
	}

	private boolean inWord;
	private float alpha_char = 0.1f;
	private float alpha_eow = 0.3f;
	private float variability = 1.0f;
	private float min_time = 0.08f;
	private float max_time = 1.8f;

	public void run() {
		char inchar;
		float alpha;
		float t;

		//read HOS parameters
		String parms = null;
		try {
			parms = System.getProperty("HumanOutput.Params");//, "{0.1, 0.3, 1.0, 0.08, 1.8}");
		} catch (RuntimeException e) {
			e.printStackTrace();
		}

		if(parms != null) {
			//first strip off trailing/leading bracket
			if(parms.charAt(0) == '{') {
				parms = parms.substring(1);
			}
			int len = parms.length();
			if(parms.charAt(len-1) == '}') {
				parms = parms.substring(0, len-1);
			}

			//now read the individual values.
			StringTokenizer st = new StringTokenizer(parms, " ,");
			int index = 0;
			while(st.hasMoreTokens()) {
				String x = st.nextToken();
				try {
					switch(index) {
						case 0: alpha_char = Float.valueOf(x).floatValue(); break;
						case 1: alpha_eow  = Float.valueOf(x).floatValue(); break;
						case 2: variability = Float.valueOf(x).floatValue(); break;
						case 3: min_time = Float.valueOf(x).floatValue(); break;
						case 4: max_time = Float.valueOf(x).floatValue(); break;
					}
				} catch (Exception e) {}
				index++;
				if(index > 4) break;
			}
		}
		
		while(true) {
			try {
				inchar = (char)in.read();
			} catch (IOException e) {
				return;
			}

			try {
				if(inWord && ( isPunct(inchar) || Character.isWhitespace(inchar))) {
					alpha = alpha_eow;
				} else {
					alpha = alpha_char;
				}

				inWord = !( isPunct(inchar) || Character.isWhitespace(inchar));

				t = (float)(alpha * Math.pow(-Math.log(unit_random()), variability));

				if(t < min_time) t = min_time;
				else if(t > max_time) t = max_time;

				lastout.write(inchar);
				lastout.flush();

				try {
					int x = (int)Math.round(t*1000);
					Thread.sleep(x);
				} catch (Exception e) {
					e.printStackTrace();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private static float unit_random() {
		return (float)((float)(1 + ( (Math.random()*2147483647) % 99991))/99991.0);
	}

	private static boolean isPunct(char c) {
		switch(Character.getType(c)) {
			case Character.DASH_PUNCTUATION:
			case Character.START_PUNCTUATION:
			case Character.END_PUNCTUATION:
			case Character.CONNECTOR_PUNCTUATION:
			case Character.OTHER_PUNCTUATION:
			case Character.MATH_SYMBOL:
			case Character.CURRENCY_SYMBOL:
			case Character.MODIFIER_SYMBOL:
				return true;
			default:
				return false;
		}
	}

	public void write(int b) throws IOException {
		out.write(b);
	}

	public void flush() throws IOException {
		lastout.flush();
	}

	public void close() throws IOException {
		lastout.close();
	}
}
