import javax.swing.*;
import javax.swing.filechooser.*;
import java.awt.*;

class DoFileDialog
{
   JFileChooser fd = null;
   int mode = FileDialog.LOAD;
   Component parent = null;
   String fname = "";

   public boolean showDialog() {
       if(fd == null) return false;
       boolean b = false;
       if(mode == FileDialog.LOAD)
           b = (fd.showOpenDialog(parent) == JFileChooser.APPROVE_OPTION ? true : false);
       else
           b = (fd.showSaveDialog(parent) == JFileChooser.APPROVE_OPTION ? true : false);
       if(b) fname = realGetPath();
       return b;
   }

   public static String GetFileName(Component p, String t, int m) {
       DoFileDialog d = new DoFileDialog(p, t, m);
       return d.getPath();
   }

   public static String GetFileName(Component p, String t, int m, FileFilter f) {
       DoFileDialog d = new DoFileDialog(p, t, m, f);
       return d.getPath();
   }

   public static String GetFileName(Component p, String t, int m, FileFilter[] f) {
       DoFileDialog d = new DoFileDialog(p, t, m, f);
       return d.getPath();
   }

   public DoFileDialog(Component Parent, String Title, int Mode)
   {
       fd = new JFileChooser();
       mode = Mode;
       parent = Parent;       
       fd.setDialogTitle(Title);
       showDialog();
   }

   public DoFileDialog(Component Parent, String Title, int Mode, FileFilter filter)
   {
       fd = new JFileChooser();
       mode = Mode;
       parent = Parent;
       fd.setFileFilter(filter);
       fd.setDialogTitle(Title);
       showDialog();
   }

   public DoFileDialog(Component Parent, String Title, int Mode, FileFilter[] filter)
   {
       fd = new JFileChooser();
       mode = Mode;
       parent = Parent;
       for(int i=0;i<filter.length;i++)
       	fd.addChoosableFileFilter(filter[i]);
       fd.setDialogTitle(Title);
       showDialog();
   }

   public FileFilter getFileFilter() {
   	if(fd == null) return null;
       return fd.getFileFilter();
   }

   public DoFileDialog(Component parent, String Title) {
       this(parent, Title, FileDialog.LOAD);
   }

   public DoFileDialog(Component parent) {
       this(parent, "Open a file", FileDialog.LOAD);
   }

   public String getPath() {
       return fname;
   }

   private String realGetPath() {
       if(fd == null) return "";
       String x = fd.getSelectedFile().getAbsolutePath();
       if(x != null)
           return x;
       else
           return "";
   }

   public static String getExtension(String fname) {
       int loc = fname.lastIndexOf('.');
       return fname.substring(loc);
   }
}
