import java.io.*;
import javax.swing.tree.*;

public class InterfaceInfo implements ElementInfo {
	int count;
	ConstantPoolInfo constants;
	InterfaceItem interfaces[];
	StatusKeeper stats;

	public InterfaceInfo(ConstantPoolInfo c, DataInputStream is, StatusKeeper y)
	{
		try
		{
			stats = y;
			constants = c;
			count = is.readUnsignedShort();
			if ( count != 0 )
			{
				interfaces = new InterfaceItem[count];
				for ( int x = 0; x < count; x++ )
					interfaces[x] = new InterfaceItem(c, is, stats, x);
			}
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		if(count == 0) {return new DefaultMutableTreeNode("No Interfaces");}

		//What do we do? We return a treenode with all the other
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Interfaces: "+count+" items.");

		//Apparently we just iterate through the items...
		for ( int x = 0; x < count; x++)
		{
			result.add(interfaces[x].Describe());
		}
		return result;
	}
}

class InterfaceItem implements ElementInfo
{
	int index;
	String s;
	StatusKeeper stats;
	int num;

	public InterfaceItem(ConstantPoolInfo c, DataInputStream is, StatusKeeper x, int y)
	{
		try
		{
			stats = x;
			num = y;
			index = is.readUnsignedShort();
			s = c.describe(index);
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		stats.setProgressText("Processing interface \""+s+"\"...", num);
		return new DefaultMutableTreeNode(s);
	}
}
