import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;

/*
 *
 * ByteCodeInfo
 *
 */
public class ByteCodeInfo implements ElementInfo
{
	ConstantPoolInfo constants;
	int code_length;
	int codepos;
	int code[];

	public ByteCodeInfo(ConstantPoolInfo c, DataInputStream is)
	{
		constants = c;
		try
		{
			code_length = is.readInt();
			code = new int[code_length];
			for (int x = 0; x < code_length; x++)
				code[x] = is.readUnsignedByte();
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Byte Codes: "+code_length+" bytes");

		codepos = 0;

		if(code.length > 16384) {
			JFrame f = new JFrame("this");
			f.setVisible(false);
			if( JOptionPane.showConfirmDialog(f, "The method I am disassembling is longer than 16,384 bytes, and the tree hasn't enough memory.\n\n"+
				"Would you like me to print the full listing to a file instead?",
				"Insufficient Memory for Disassembly",
				JOptionPane.YES_NO_OPTION,
				JOptionPane.QUESTION_MESSAGE)

			== JOptionPane.YES_OPTION){
				SimpleFileFilter filter = new SimpleFileFilter("txt", "Save a method dump");

				String s = DoFileDialog.GetFileName(f, "Save a method dump", FileDialog.SAVE, filter);
				if(!s.equals("") ) {
				  try{
					FileOutputStream outFile = new FileOutputStream(s);
					DataOutputStream os = new DataOutputStream(new BufferedOutputStream(outFile));
					while ( codepos < code.length )
						os.writeBytes(decodeBytes()+"\r\n");
					os.flush();
					outFile.close();
					codepos = 0;
				  } catch (IOException e) {e.printStackTrace();}
				}
			}
		}

		while ( codepos < code.length )
			if(codepos > 16384){
				result.add(new DefaultMutableTreeNode("Method too large--bytes after 16K ignored."));
				break;
			}
			else
				result.add(new DefaultMutableTreeNode(decodeBytes()));

		return result;
	}

	protected String decodeBytes()
	{
		int count;
		StringBuffer buf = new StringBuffer();
		buf.append("" + codepos + " ");
//	   System.out.print(""+ codepos + '\r');
		switch ( code[codepos++] )
		{
		case 0:
			buf.append("nop					No operation");
			break;
		case 1:
			buf.append("aconst_null			Push Null Object");
			break;
		case 2:
			buf.append("iconst_m1			  Push -1");
			break;
		case 3:
			buf.append("iconst_0			   Push 0");
			break;							 
		case 4:
			buf.append("iconst_1			   Push 1");
			break;							 
		case 5:								
			buf.append("iconst_2			   Push 2");
			break;
		case 6:
			buf.append("iconst_3			   Push 3");
			break;
		case 7:
			buf.append("iconst_4			   Push 4");
			break;							 
		case 8:
			buf.append("iconst_5			   Push 5");
			break;							 
		case 9:								
			buf.append("lconst_0			   Push 0L");
			break;
		case 10:							   
			buf.append("lconst_1			   Push 1L");
			break;
		case 11:
			buf.append("fconst_0			   Push 0.0");
			break;
		case 12:
			buf.append("fconst_1			   Push 1.0");
			break;
		case 13:
			buf.append("fconst_2			   Push 2.0");
			break;
		case 14:
			buf.append("dconst_0			   Push 0.0 (double)");
			break;
		case 15:
			buf.append("dconst_1			   Push 1.0 (double)");
			break;
		case 16:
			buf.append("bipush" + enumBytes(1)+"			 Push One-Byte Signed Integer");
			break;
		case 17:
			buf.append("sipush" + enumWords(1)+"			 Push Two-Byte Signed Integer");
			break;
		case 18:
			buf.append("ldc1" + poolIndex(1)+"			   Push Item From Constant Pool (8 bit index)");
			break;
		case 19:
			buf.append("ldc2" + poolIndex(2)+"			   Push Item From Constant Pool (16 bit index)");
			break;
		case 20:
			buf.append("ldc2w" + poolIndex(2)+"			  Push Long or Double from Constant Pool (16 bit index)");
			break;
		case 21:
			buf.append("iload" + enumBytes(1)+"			  Push contents of vars[" + code[codepos - 1] + "]");
			break;
		case 22:
			buf.append("lload" + enumBytes(1)+"			  Push Long from vars[" + code[codepos - 1] + "] & vars[" + (code[codepos - 1] + 1) + "]");
			break;
		case 23:
			buf.append("fload" + enumBytes(1)+"			  Push Float from vars[" + code[codepos - 1] + "]");
			break;
		case 24:
			buf.append("dload" + enumBytes(1)+"			  Push Double from vars[" + code[codepos - 1] + "] & vars[" + (code[codepos - 1] + 1) + "]");
			break;													
		case 25:
			buf.append("aload" + enumBytes(1)+"			  Push Object from vars[" + code[codepos - 1] + "]");
			break;
		case 26:
			buf.append("iload_0				Push Integer from vars[0] (this pointer)");
			break;
		case 27:
			buf.append("iload_1				Push Integer from vars[1]");
			break;
		case 28:
			buf.append("iload_2				Push Integer from vars[2]");
			break;
		case 29:
			buf.append("iload_3				Push Integer from vars[3]");
			break;
		case 30:
			buf.append("lload_0				Push Long from vars[0] & vars[1]");
			break;
		case 31:
			buf.append("lload_1				Push Long from vars[1] & vars[2]");
			break;
		case 32:
			buf.append("lload_2				Push Long from vars[2] & vars[3]");
			break;
		case 33:
			buf.append("lload_3				Push Long from vars[3] & vars[4]");
			break;
		case 34:
			buf.append("fload_0				Push Float from vars[0]");
			break;
		case 35:
			buf.append("fload_1				Push Float from vars[1]");
			break;
		case 36:
			buf.append("fload_2				Push Float from vars[2]");
			break;
		case 37:
			buf.append("fload_3				Push Float from vars[3]");
			break;
		case 38:
			buf.append("dload_0				Push Double from vars[0] & vars[1]");
			break;
		case 39:
			buf.append("dload_1				Push Double from vars[1] & vars[2]");
			break;
		case 40:
			buf.append("dload_2				Push Double from vars[2] & vars[3]");
			break;
		case 41:
			buf.append("dload_3				Push Double from vars[3] & vars[4]");
			break;
		case 42:
			buf.append("aload_0				Push Object from vars[0] (this)");
			break;
		case 43:
			buf.append("aload_1				Push Object from vars[1]");
			break;
		case 44:
			buf.append("aload_2				Push Object from vars[2]");
			break;
		case 45:
			buf.append("aload_3				Push Object from vars[3]");
			break;
		case 46:
			buf.append("iaload				 Push Integer from array on stack");
			break;
		case 47:
			buf.append("laload				 Push long from array on stack");
			break;
		case 48:
			buf.append("faload				 Push Float from array on stack");
			break;
		case 49:
			buf.append("daload				 Push Double from array on stack");
			break;
		case 50:
			buf.append("aaload				 Push Object from array on stack");
			break;
		case 51:
			buf.append("baload				 Push Byte from array on stack");
			break;
		case 52:
			buf.append("caload				 Push Char from array on stack");
			break;
		case 53:
			buf.append("saload				 Push Short from array on stack");
			break;
		case 54:
			buf.append("istore" + enumBytes(1)+"			 Store Integer on stack into vars[" + code[codepos - 1] + "]");
			break;
		case 55:
			buf.append("lstore" + enumBytes(1)+"			 Store Long on stack into vars[" + code[codepos - 1] + "]");
			break;
		case 56:
			buf.append("fstore" + enumBytes(1)+"			 Store Float on stack into vars[" + code[codepos - 1] + "]");
			break;
		case 57:
			buf.append("dstore" + enumBytes(1)+"			 Store Double on stack into vars[" + code[codepos - 1] + "] & vars[" + (code[codepos - 1] + 1) + "]");
			break;
		case 58:
			buf.append("astore" + enumBytes(1)+"			 Store Object on stack into vars[" + code[codepos - 1] + "]");
			break;
		case 59:
			buf.append("istore_0			   Store Integer on stack into vars[0]");
			break;
		case 60:
			buf.append("istore_1			   Store Integer on stack into vars[1]");
			break;
		case 61:
			buf.append("istore_2			   Store Integer on stack into vars[2]");
			break;
		case 62:
			buf.append("istore_3			   Store Integer on stack into vars[3]");
			break;
		case 63:							   
			buf.append("lstore_0			   Store Long on stack into vars[0] & vars[1]");
			break;
		case 64:
			buf.append("lstore_1			   Store Long on stack into vars[1] & vars[2]");
			break;
		case 65:
			buf.append("lstore_2			   Store Long on stack into vars[2] & vars[3]");
			break;
		case 66:
			buf.append("lstore_3			   Store Long on stack into vars[3] & vars[4]");
			break;
		case 67:
			buf.append("fstore_0			   Store Float on stack into vars[0]");
			break;
		case 68:
			buf.append("fstore_1			   Store Float on stack into vars[1]");
			break;
		case 69:
			buf.append("fstore_2			   Store Float on stack into vars[2]");
			break;
		case 70:
			buf.append("fstore_3			   Store Float on stack into vars[3]");
			break;
		case 71:
			buf.append("dstore_0			   Store Double on stack into vars[0] & vars[1]");
			break;
		case 72:
			buf.append("dstore_1			   Store Double on stack into vars[1] & vars[2]");
			break;
		case 73:
			buf.append("dstore_2			   Store Double on stack into vars[2] & vars[3]");
			break;
		case 74:
			buf.append("dstore_3			   Store Double on stack into vars[3] & vars[4]");
			break;
		case 75:
			buf.append("astore_0			   Store Object on stack into vars[0]");
			break;
		case 76:
			buf.append("astore_1			   Store Object on stack into vars[1]");
			break;
		case 77:
			buf.append("astore_2			   Store Object on stack into vars[2]");
			break;
		case 78:
			buf.append("astore_3			   Store Object on stack into vars[3]");
			break;
		case 79:
			buf.append("iastore				Store Integer on stack into array on stack");
			break;
		case 80:
			buf.append("lastore				Store Long on stack into array on stack");
			break;
		case 81:
			buf.append("fastore				Store Float on stack into array on stack");
			break;
		case 82:
			buf.append("dastore				Store Double on stack into array on stack");
			break;
		case 83:
			buf.append("aastore				Store Object on stack into array on stack");
			break;
		case 84:
			buf.append("bastore				Store Byte on stack into array on stack");
			break;
		case 85:
			buf.append("castore				Store Char on stack into array on stack");
			break;
		case 86:
			buf.append("sastore				Store Short on stack into array on stack");
			break;
		case 87:
			buf.append("pop					Remove top stack element");
			break;
		case 88:
			buf.append("pop2				   Remove top two stack elements");
			break;
		case 89:
			buf.append("dup					Insert a copy of top stack element at stack[top]");
			break;
		case 90:
			buf.append("dup_x1				 Insert a copy of top stack element at stack[top - 1]");
			break;
		case 91:
			buf.append("dup_x2				 Insert a copy of top stack element at stack[top - 2]");
			break;
		case 92:
			buf.append("dup2				   Insert a copy of top two stack elements at stack[top]");
			break;
		case 93:
			buf.append("dup2_x1				Insert a copy of top two stack elements at stack[top - 1]");
			break;
		case 94:
			buf.append("dup2_x2				Insert a copy of top two stack elements at stack[top - 2]");
			break;
		case 95:
			buf.append("swap				   Swap top two stack elements");
			break;
		case 96:
			buf.append("iadd				   Add top two stack integers");
			break;
		case 97:
			buf.append("ladd				   Add top two stack longs");
			break;
		case 98:
			buf.append("fadd				   Add top two stack floats");
			break;
		case 99:
			buf.append("dadd				   Add top two stack doubles");
			break;
		case 100:
			buf.append("isub				   Subtract top two stack integers");
			break;
		case 101:
			buf.append("lsub				   Subtract top two stack longs");
			break;
		case 102:
			buf.append("fsub				   Subtract top two stack floats");
			break;
		case 103:
			buf.append("dsub				   Subtract top two stack doubles");
			break;
		case 104:
			buf.append("imul				   Multiply top two stack integers");
			break;
		case 105:
			buf.append("lmul				   Multiply top two stack longs");
			break;
		case 106:
			buf.append("fmul				   Multiply top two stack floats");
			break;
		case 107:
			buf.append("dmul				   Multiply top two stack doubles");
			break;
		case 108:
			buf.append("idiv				   Divide top two stack integers");
			break;
		case 109:
			buf.append("ldiv				   Divide top two stack longs");
			break;
		case 110:
			buf.append("fdiv				   Divide top two stack floats");
			break;
		case 111:
			buf.append("ddiv				   Divide top two stack doubles");
			break;
		case 112:
			buf.append("irem				   Remainder of top two stack integers");
			break;
		case 113:
			buf.append("lrem				   Remainder of top two stack longs");
			break;
		case 114:
			buf.append("frem				   Remainder of top two stack floats");
			break;
		case 115:							  
			buf.append("drem				   Remainder of top two stack doubles");
			break;
		case 116:
			buf.append("ineg				   Negate top stack integer");
			break;
		case 117:
			buf.append("lneg				   Negate top stack long");
			break;
		case 118:
			buf.append("fneg				   Negate top stack float");
			break;
		case 119:
			buf.append("dneg				   Negate top stack double");
			break;
		case 120:
			buf.append("ishl				   Shift left stack integer by stack top bits");
			break;
		case 121:
			buf.append("lshl				   Shift left stack long by stack top bits");
			break;
		case 122:
			buf.append("ishr				   Shift right stack integer by stack top bits");
			break;
		case 123:
			buf.append("lshr				   Shift right stack long by stack top bits");
			break;
		case 124:
			buf.append("iushr				  Unsigned right integer shift by stack top bits");
			break;
		case 125:
			buf.append("lushr				  Unsigned right long shift by stack top bits");
			break;
		case 126:
			buf.append("iand				   Logical AND of top two stack integers");
			break;
		case 127:
			buf.append("land				   Logical AND of top two stack longs");
			break;
		case 128:
			buf.append("ior					Logical OR of top two stack integers");
			break;
		case 129:
			buf.append("lor					Logical OR of top two stack longs");
			break;
		case 130:
			buf.append("ixor				   Logical XOR of top two stack integers");
			break;
		case 131:
			buf.append("lxor				   Logical XOR of top two stack longs");
			break;
		case 132:
			buf.append("iinc" + enumBytes(1) + " " + (byte)code[codepos++]+"		   Increment vars[" + code[codepos - 2] + "] by " + (byte)code[codepos - 1]);
			break;
		case 133:
			buf.append("i2l					Convert stack integer to long");
			break;
		case 134:
			buf.append("i2f					Convert stack integer to float");
			break;
		case 135:
			buf.append("i2d					Convert stack integer to double");
			break;
		case 136:
			buf.append("l2i					Convert stack long to integer");
			break;
		case 137:
			buf.append("l2f					Convert stack long to float");
			break;
		case 138:
			buf.append("l2d					Convert stack long to double");
			break;
		case 139:
			buf.append("f2i					Convert stack float to integer");
			break;
		case 140:
			buf.append("f2l					Convert stack float to long");
			break;
		case 141:
			buf.append("f2d					Convert stack float to double");
			break;
		case 142:
			buf.append("d2i					Convert stack double to integer");
			break;
		case 143:
			buf.append("d2l					Convert stack double to long");
			break;
		case 144:
			buf.append("d2f					Convert stack double to float");
			break;
		case 145:
			buf.append("int2byte			   Convert stack integer to byte");
			break;
		case 146:
			buf.append("int2char			   Convert stack integer to char");
			break;
		case 147:
			buf.append("int2short			  Convert stack integer to short");
			break;
		case 148:
			buf.append("lcmp				   Compare top two longs");
			break;
		case 149:
			buf.append("fcmpl				  Compare top two floats (-1 on NaN)");
			break;
		case 150:
			buf.append("fcmpg				  Compare top two floats (1 on NaN)");
			break;
		case 151:
			buf.append("dcmpl				  Compare top two doubles (-1 on NaN)");
			break;
		case 152:
			buf.append("dcmpg				  Compare top two doubles (1 on NaN)");
			break;
		case 153:
			buf.append("ifeq" + branchLocation()+"			   Branch if stack top equals zero");
			break;
		case 154:
			buf.append("ifne" + branchLocation()+"			   Branch if stack top not equal zero");
			break;
		case 155:
			buf.append("iflt" + branchLocation()+"			   Branch if stack top less than zero");
			break;
		case 156:
			buf.append("ifge" + branchLocation()+"			   Branch if stack top greater than or equal to zero");
			break;
		case 157:
			buf.append("ifgt" + branchLocation()+"			   Branch if stack top greater than zero");
			break;
		case 158:
			buf.append("ifle" + branchLocation()+"			   Branch if stack top less than or equal to zero");
			break;
		case 159:
			buf.append("if_icmpeq" + branchLocation()+"		  Branch if top two stack integers are equal");
			break;
		case 160:
			buf.append("if_icmpne" + branchLocation()+"		  Branch if top two stack integers are not equal");
			break;
		case 161:
			buf.append("if_icmplt" + branchLocation()+"		  Branch if top two stack integers are equal");
			break;
		case 162:
			buf.append("if_icmpge" + branchLocation()+"		  Branch if top two stack integers are greater than or equal");
			break;
		case 163:
			buf.append("if_icmpgt" + branchLocation()+"		  Branch if top two stack integers are greater than");
			break;
		case 164:
			buf.append("if_icmple" + branchLocation()+"		  Branch if top two stack integers less than or equal");
			break;
		case 165:
			buf.append("if_acmpeq" + branchLocation()+"		  Branch if top two stack objects are equal");
			break;
		case 166:
			buf.append("if_acmpne" + branchLocation()+"		  Branch if top two stack objects are not equal");
			break;
		case 167:
			buf.append("goto" + branchLocation());
			break;
		case 168:
			buf.append("jsr " + branchLocation()+"			   Execute subroutine");
			break;
		case 169:
			buf.append("ret" + enumBytes(1)+"				Return from subroutine (return address stored in vars[" + code[codepos - 1] + "]");
			break;
		case 170:
			buf.append("tableswitch");
			while ( codepos % 4 != 0 )
				codepos++;
			buf.append(" default:" + enumDwords(1));
			int low = getDword();
			int high = getDword();
			count = (high - low) + 1;
			while (count != 0)
			{
				codepos += 4;
				count--;
			}
			break;
		case 171:
			buf.append("lookupswitch");
			while ( codepos % 4 != 0 )
				codepos++;
			buf.append(" default:" + enumDwords(1));
			count = getDword();
			while (count != 0)
			{
				codepos += 4;
				count--;
			}
			break;
		case 172:
			buf.append("ireturn				Return Integer on stack top");
			break;
		case 173:
			buf.append("lreturn				Return Long on stack top");
			break;
		case 174:
			buf.append("freturn				Return Float on stack top");
			break;
		case 175:
			buf.append("dreturn				Return Double on stack top");
			break;
		case 176:
			buf.append("areturn				Return Object on stack top");
			break;
		case 177:
			buf.append("return				 Return w/o object");
			break;
		case 178:
			buf.append("getstatic" + poolIndex(2) +"		  Push contents of static field");
			break;
		case 179:
			buf.append("putstatic" + poolIndex(2)+"		   Store stack top into static field");
			break;
		case 180:
			buf.append("getfield" + poolIndex(2)+"			Push contents of field");
			break;
		case 181:
			buf.append("putfield" + poolIndex(2)+"			Store stack top into field");
			break;
		case 182:
			buf.append("invokevirtual" + poolIndex(2));
			break;
		case 183:
			buf.append("invokenonvirtual" + poolIndex(2));
			break;
		case 184:
			buf.append("invokestatic" + poolIndex(2));
			break;
		case 185:
			buf.append("invokeinterface" + poolIndex(2));
			buf.append(enumBytes(1));
			codepos++;	// account for reserved byte
			break;
		case 186:
			buf.append("newfromname			Create a new Object using name on stack top");
			break;
		case 187:
			buf.append("new" + poolIndex(2)+"			   Create a new Object on stack top");
			break;
		case 188:
			buf.append("newarray" + enumBytes(1)+"		   Create a new array of type " + code[codepos - 1]);
			break;
		case 189:
			buf.append("anewarray" + poolIndex(2)+"			Allocate a new array of Objects");
			break;
		case 190:
			buf.append("arraylength			Get length of array on stack top");
			break;
		case 191:
			buf.append("athrow				 Throw exception at stack top");
			break;
		case 192:
			buf.append("checkcast" + poolIndex(2)+"		  Verify cast against stack top Object");
			break;
		case 193:
			buf.append("instanceof" + poolIndex(2)+"		 Check instance of stack top Object");
			break;
		case 194:
			buf.append("monitorenter		   Enter Thread Monitor");
			break;
		case 195:
			buf.append("monitorexit			Exit Thread Monitor");
			break;
		case 196:
			buf.append("wide" + enumBytes(1)+"		   Next instruction uses a 16 bit index");
			break;
		case 197:
			buf.append("multianewarray" + poolIndex(2) + enumBytes(1)+" Allocate a multi dimensional array of dimension " + code[codepos - 1]);
			break;
		case 198:
			buf.append("ifnull 052			 Branch if stack top is NULL");
			buf.append("ifnull" + branchLocation()+"			 Branch if stack top is NULL");
			break;
		case 199:
			buf.append("ifnonnull" + branchLocation()+"		  Branch if stack top is not NULL");
			break;
		case 200:
			buf.append("goto_w" + wbranchLocation());
			break;
		case 201:
			buf.append("jsr_w" + wbranchLocation());
			break;
		case 202:
			buf.append("breakpoint");
			break;
		case 209:
			buf.append("ret_w" + enumWords(1));
			break;
		default:
			buf.append("Unknown Byte Code " + code[codepos - 1]);
			break;
		}
		return buf.toString();
	}

	protected String enumBytes(int count)
	{
		StringBuffer buf = new StringBuffer();

		while(count != 0)
		{
			buf.append(" " + code[codepos++]);
			count--;
		}
		return buf.toString();
	}

	protected String enumWords(int count)
	{
		StringBuffer buf = new StringBuffer();

		while (count != 0)
		{
			int val = (256 * code[codepos]) + code[codepos + 1];
			buf.append(" " + val);
			codepos += 2;
			count--;
		}
		return buf.toString();
	}

	protected String enumDwords(int count)
	{
		StringBuffer buf = new StringBuffer();

		while (count != 0)
		{
			int val = 0;

			val = code[codepos];
			val *= 256;
			val += code[codepos + 1];
			val *= 256;
			val += code[codepos + 2];
			val *= 256;
			val += code[codepos + 3];
			buf.append(" " + val);
			codepos += 4;
			count--;
		}
		return buf.toString();
	}

	protected int getDword()
	{
		int val = 0;

		val = code[codepos];
		val *= 256;
		val += code[codepos + 1];
		val *= 256;
		val += code[codepos + 2];
		val *= 256;
		val += code[codepos + 3];
		codepos += 4;
		return val;
	}

	protected String poolIndex(int count)
	{
		StringBuffer buf = new StringBuffer();
		int val = 0;

		while (count != 0)
		{
			val *= 256;
			val += code[codepos++];
			count--;
		}
		return " #" + val + " <" + constants.describe(val) + ">";
	}

	protected String branchLocation()
	{
		int val = 0;
		short v;

		val = code[codepos++] * 256;
		val += code[codepos++];
		v = (short)val;
		v += (short)(codepos - 3);
		return " " + v;
	}

	protected String wbranchLocation()
	{
		int val = 0;

		val = code[codepos++] * 256;
		val += code[codepos++];
		val *= 256;
		val += code[codepos++];
		val *= 256;
		val += code[codepos++];
		val += (codepos - 5);
		return " " + val;
	}
}
