package grid.worker;

import grid.util.Defaults;
import grid.util.LocalProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

public class Main {
	private WorkerTableModel wtm;
	private List workerList;

	public Main() {
		workerList = new ArrayList();
		wtm = new WorkerTableModel(workerList);
	}

	private static void printHelp() {
		System.out.println("Usage: grid.worker.Main <server> <workers>");
	}

	public static void main(String args[]) {
		if(args.length > 0) {
			if(args[0].equalsIgnoreCase("--help")) {
				printHelp();
				return;
			}
			System.setProperty("grid.worker.Worker.server", args[0]);
		}
		if(args.length > 1) {
			try {
				Integer.parseInt(args[1]);
				System.setProperty("grid.worker.Worker.workers", args[1]);
			} catch (Exception e) {}
		}

		Main m = new Main();
		m.run();
	}

	public void run() {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String input;

		System.out.println(Defaults.version);
		try {
			while(true) {
				System.out.print("worker> ");
				input = br.readLine();
				if(input == null) {
					System.out.println("");
					return;
				}
				dispatch(tokenize(input));
			}
		} catch (Exception e) {e.printStackTrace();}
	}

	private String[] tokenize(String x) {
		StringTokenizer st = new StringTokenizer(x);
		List l = new ArrayList();

		while(st.hasMoreTokens()) {
			l.add(st.nextToken());
		}
		
		return (String[]) l.toArray(new String[0]);
	}

	private void dispatch(String commands[]) {
		if(commands.length < 1) return;

		if(commands[0].equalsIgnoreCase("quit")
			|| commands[0].equalsIgnoreCase("exit")
		) {
			System.exit(0);
		} else if(commands[0].equalsIgnoreCase("ls")) {
			listWorkers(commands);
		} else if(commands[0].equalsIgnoreCase("stop")) {
			stopWorker(commands);
		} else if(commands[0].equalsIgnoreCase("kill")) {
			killWorker(commands);
		} else if(commands[0].equalsIgnoreCase("add")) {
			addWorker(commands);
		} else {
			System.out.println("worker: "+commands[0]+": command not found.");
		}
	}

	private void listWorkers(String args[]) {
		int x = wtm.getColumnCount();
		for(int i = 0; i < x; i++) {
			System.out.print(wtm.getColumnName(i)+"\t");
		}
		System.out.println("");

		int y = wtm.getRowCount();
		for(int i = 0; i < y; i++) {
			for(int j = 0; j < x; j++) {
				System.out.print(wtm.getValueAt(i, j)+"\t");
			}
			System.out.println("");
		}
	}

	private void addWorker(String args[]) {
		String server = LocalProperties.getProperty("grid.worker.Worker.server",
			Defaults.server
		);
		
		int workers = Integer.parseInt(LocalProperties.getProperty(
			"grid.worker.Worker.workers", Defaults.sWorkers));
		
		if(args.length >= 3) {
			server = args[1];
			try {
				workers = Integer.parseInt(args[2]);
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("Usage: add [<server> <workers>]");
				return;
			}
		}

		if(workers < 1) {
			workers = 1;
		}

		for(int i = 0; i < workers; i++) {
			Worker w = new Worker(server);
			w.start();
			workerList.add(w);
		}
	}

	private void stopWorker(String args[]) {
		if(args.length == 1) {
			System.out.println("Usage: stop <worker id> [<worker id>...]");
			return;
		}

		for(int i = 1; i < args.length; i++) {
			int wid;
			try {
				wid = Integer.parseInt(args[i]);
			} catch (Exception e) {
				System.out.println("Invalid worker ID: "+args[i]);
				continue;
			}

			if(wid >= workerList.size() || wid < 0) continue;
				
			Worker w = (Worker)workerList.get(wid);

			if(w.getStatus() != Worker.RUNNING) continue;

			w.abortTask();
		}
	}

	private void killWorker(String args[]) {
		if(args.length == 1) {
			System.out.println("Usage: kill <worker id> [<worker id>...]");
			return;
		}

		List deleteList = new ArrayList();

		for(int i = 1; i < args.length; i++) {
			int wid;
			try {
				wid = Integer.parseInt(args[i]);
			} catch (Exception e) {
				System.out.println("Invalid worker ID: "+args[i]);
				continue;
			}

			if(wid >= workerList.size() || wid < 0) continue;
				
			Worker w = (Worker)workerList.get(wid);

			w.abortTask();
			w.interrupt();

			deleteList.add(w);
		}

		Iterator i = deleteList.iterator();
		while(i.hasNext()) {
			workerList.remove(i.next());
		}
	}
}
