import java.net.*;
import java.io.*;
import java.util.*;

public class IPScan {
   public static void main(String args[]) {
       System.out.println("IP Scanner 1.1 by DWong");
       if(args.length < 3) {
           System.out.print(
               "\n" +
               "Usage: java HttpPortScan startIP endIP port outdir\n" +
               "\n" +
               "  startIP   IP address to start scanning from.\n" +
               "  endIP     IP address to end scanning.\n" +
               "  port      port on which to send HTTP requests.\n" +
               "  outdir    Folder to put the results into.\n"
           );
           return;
       }

       long start = IPAddressUtils.getStringAsLong(args[0]);
       long end = IPAddressUtils.getStringAsLong(args[1]);
       int port = Integer.parseInt(args[2]);
       if((port < 0) || (port > 65535)) port = 80;
       String outdir = args[3];

       ScannerCount sc = new ScannerCount();

       for(long i = start; i <= end; i++) {
           MakeHttpRequest mhr = new MakeHttpRequest(sc);
           mhr.i = i;
           mhr.port = port;
           mhr.outdir = outdir;
           mhr.start();
           sc.incScannerCount();
       }
       sc.start();
   }
}

class ScannerCount extends Thread {
   private int scannerCount = 0;
   public final int getScannerCount() {return scannerCount;}
   public final synchronized void setScannerCount(int t) {scannerCount = t;}
   public final void incScannerCount() {scannerCount++;}
   public final synchronized void decScannerCount() {scannerCount--;}

   public void run() {
       while(true) {
           System.out.println("Scanners remaining: " + scannerCount);
           if(scannerCount < 1) System.exit(0);
           try {
               sleep(500);
           } catch (InterruptedException e) {}
       }
   }
}

class MakeHttpRequest extends Thread {
   public long i;
   public int port;
   public String outdir;
   private ScannerCount sc;

   public MakeHttpRequest(ScannerCount m_sc) {sc = m_sc;}

   public void run() {
       String ip = IPAddressUtils.getLongAsString(i);
       try {
           String earl = "http://"+ip+":"+port+"/";
           String out = outdir + ip+"_"+port+".html";
           System.out.println(ip + ": Now trying "+earl+"...");
           URL sourceurl = new URL(earl);

           //open connection
           URLConnection sourceurlc = sourceurl.openConnection();
           sourceurlc.connect();
           InputStream remotefileis = sourceurlc.getInputStream();

            //now construct URL
           System.out.println(ip + ": Copying "+earl+" to "+out+"...");

           //now get the local file...
           OutputStream localfileos = new FileOutputStream(out);

           copyFile(sourceurlc.getContentLength(), remotefileis, localfileos);
           localfileos.flush();
           localfileos.close();
       } catch (Exception ex) {
           System.out.println(ip + ": " +ex.getLocalizedMessage()+".");
       }
       System.out.println(ip + ": Finished.");
       sc.decScannerCount();
   }
   private static void copyFile(int length, InputStream i, OutputStream o) throws Exception {
       int in, read = 0;

       do {
           in = i.available();
           if(in < 1) continue;
           read += in;
           byte[] b = new byte[in];
           i.read(b);
           o.write(b);
       } while (read < length);

       i.close();
       o.close();
   }
   
}