import java.io.*;
import java.util.*;
import java.net.*;

public class PrintSend {
    public static void main(String args[]) {
        String sPrinterIP = "library1";
        int iPort = 9100;

        int j = args.length;
        int i = 0;
        while(i < j) {
            String s = args[i];
            if(s.equals("-?")) {
                displaySyntax(); return;
            } else if(s.equals("/?")) {
                displaySyntax(); return;
            } else if(s.equals("port")) {
                iPort = (j>i+1?Integer.parseInt(args[i++]):iPort);
            } else if(s.equals("printer")){
                sPrinterIP = (j > i+1?args[i++]:sPrinterIP);
            } else if(s.equals("u")){
                try {
                    printUrl(sPrinterIP, iPort, new URL(args[i++]));
                } catch (Exception e) {e.printStackTrace();}
            } else if(s.equals("f")){
                try {
                    printFile(sPrinterIP, iPort, args[i++]);
                } catch (Exception e) {e.printStackTrace();}
            }
            i++;
        }
    }

    private static void displaySyntax() {
        System.out.println("Prints files to ports");
        System.out.println("");
        System.out.println("java PrintSend [port p] [printer ip] [u url]... [f files]...");
        System.out.println("");
        System.out.println("    p       The printer's IP address.  Default: library1");
        System.out.println("    ip      The port of the printer.  Default: 9100");
        System.out.println("    url     The URL of file to print.");
        System.out.println("    file    The files to send.");
        System.out.println("");
        System.out.println("You may put any commands in any order.");
    }

    private static void printFile(String sPrinterIP, int iPort, String sFile) {
        String spip = sPrinterIP.toLowerCase();
        if(spip.equals("library1")) {
            sPrinterIP = "172.20.9.199";
        } else if(spip.equals("library2")) {
            sPrinterIP = "172.20.9.207";
        } else if(spip.equals("mmr")) {
            sPrinterIP = "172.20.8.15";
        } else if(spip.equals("langlab")) {
            sPrinterIP = "172.20.9.82";
        } else if(spip.equals("loopback")) {
            sPrinterIP = "127.0.0.1";
        }

        FileInputStream fisPrintJob = null;
        File fPrintJob = null;
        try {
            fisPrintJob = new FileInputStream(sFile);
            fPrintJob = new File(sFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //now get the local file...
        //this is the Menlo-specific version.
        //Hopefully the printer IP doesn't change...
        //better yet, set an option for the config file...later?

        boolean gotConnection = false;
        Socket sPrinter = null;
        OutputStream osPrinter = null;
        System.out.println("PRINT: Trying to open "+sPrinterIP+":"+iPort+"...");
        do {
            try {
                sPrinter = new Socket(sPrinterIP, iPort);
                gotConnection = true;
            } catch (java.net.ConnectException e) {
                System.out.println("PRINT: Connection refused, will try again in 10s..");
                gotConnection = false;
                try { Thread.sleep(10000); } catch (InterruptedException ez) {}
            } catch (Exception uhe) {
                uhe.printStackTrace();
            }
        } while( (gotConnection == false) || (sPrinter == null) );

        try {
            System.out.println("PRINT: Connected to printer @ "+sPrinterIP+":"+iPort+".  Sending file...");
            osPrinter = sPrinter.getOutputStream();
            copyFile((int)fPrintJob.length(), fisPrintJob, osPrinter);
            osPrinter.flush();
            osPrinter.close();
            fisPrintJob.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("PRINT: Job sent to printer.");
    }

    private static void printUrl(String sPrinterIP, int iPort, URL uPrintJob) {
        String spip = sPrinterIP.toLowerCase();
        if(spip.equals("library1")) {
            sPrinterIP = "172.20.9.199";
        } else if(spip.equals("library2")) {
            sPrinterIP = "172.20.9.207";
        } else if(spip.equals("mmr")) {
            sPrinterIP = "172.20.8.15";
        } else if(spip.equals("langlab")) {
            sPrinterIP = "172.20.9.82";
        } else if(spip.equals("loopback")) {
            sPrinterIP = "127.0.0.1";
        }

        URLConnection ucPrintJob = null;
        InputStream isPrintJob = null;
        try {
            ucPrintJob = uPrintJob.openConnection();
            ucPrintJob.connect();
            isPrintJob = ucPrintJob.getInputStream();
        } catch (Exception e) {
            e.printStackTrace();
        }
        //now get the local file...
        //this is the Menlo-specific version.
        //Hopefully the printer IP doesn't change...
        //better yet, set an option for the config file...later?

        boolean gotConnection = false;
        Socket sPrinter = null;
        OutputStream osPrinter = null;
        System.out.println("PRINT: Trying to open "+sPrinterIP+":"+iPort+"...");
        do {
            try {
                sPrinter = new Socket(sPrinterIP, iPort);
                gotConnection = true;
            } catch (java.net.ConnectException e) {
                System.out.println("PRINT: Connection refused, will try again in 10s..");
                gotConnection = false;
                try { Thread.sleep(10000); } catch (InterruptedException ez) {}
            } catch (Exception uae) {
                uae.printStackTrace();
            }
        } while( (gotConnection == false) || (sPrinter == null) );

        try {
            System.out.println("PRINT: Connected to printer @ "+sPrinterIP+":"+iPort+".  Sending file...");
            osPrinter = sPrinter.getOutputStream();

            copyFile(ucPrintJob.getContentLength(), isPrintJob, osPrinter);

            osPrinter.flush();
            osPrinter.close();
            isPrintJob.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("PRINT: Job sent to printer.");
    }

    private static void copyFile(int length, InputStream i, OutputStream o) throws Exception {
        int in, read = 0;

        do {
            in = i.available();
            if(in < 1) continue;
            read += in;
            byte[] b = new byte[in];
            i.read(b);
            o.write(b);
        } while (read < length);
 
        i.close();
        o.close();
    }
}
