import java.applet.*;
import java.net.URL;
import java.security.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class InstallJar extends Applet implements IScript, WindowListener, ActionListener {
   private Wizard p;
   private int current = 0;
   private String sJavaVer = "unknown";

   public boolean isApp = false;

   private static final String name = "Java Extension (JAR)";

   public void onNext() {
       unsetPage(current);
       current++;
       setPage(current, true);
   }

   public void onBack() {
       unsetPage(current);
       current--;
       setPage(current, false);
   }

   private void unsetPage(int page) {
       switch(page) {
           case 1: {
               Checkbox cb = cgPlatform.getSelectedCheckbox();
               String s = cb.getLabel();
               if(s.equals("Windows 95/98")) {
                   iPlatform = 1;
               } else if(s.equals("Windows NT")) {
                   iPlatform = 2;
               } else if(s.equals("MacOS")) {
                   iPlatform = 3;
               } else if(s.equals("Unix")) {
                   iPlatform = 4;
               }
               break;
           } case 2: {
               bNS4 = cbNS4.getState();
               bIE4 = cbIE4.getState();
               bHotJava = cbHotJava.getState();
               bJDK11 = cbJDK11.getState();
               bMRJ21 = cbMRJ21.getState();
               bJava12 = cbJava12.getState();
           }
       }
   }

   private MyLabel l = new MyLabel();

   private Panel pPlatform = null;
   private CheckboxGroup cgPlatform = new CheckboxGroup();
   private int iPlatform = 0;

   private Panel pBrowsers = null;
   private Checkbox
       cbNS4     = new Checkbox("Netscape 4.x"),
       cbIE4     = new Checkbox("Internet Explorer 4.x"),
       cbHotJava = new Checkbox("HotJava"),
       cbJDK11   = new Checkbox("JDK 1.1"),
       cbMRJ21   = new Checkbox("MRJ 2.1"),
       cbJava12  = new Checkbox("Any Java 1.2 platform");
   private boolean bNS4, bIE4, bHotJava, bJDK11, bMRJ21, bJava12;

   private String getBrowserConfig() {
       StringBuffer sb = new StringBuffer("Following are instructions to set up the JAR file.\n");
       sb.append("\n");
       int iStep = 1;
       boolean bModClassPath = false;

       sb.append((iStep++)+")\tFirst, download the JAR file.\n");
       if(bJava12) sb.append((iStep++)+")\tMove the file to the folder \"/lib/ext\" under wherever Java 1.2 is installed.  If there is no such folder, create it.\n");

       switch(iPlatform) {
           case 1: { //win9x
               if(bNS4) {
                   if(!bJava12) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/Program/Java/Classes\" in the Netscape folder.\n");
                   } else {
                       bModClassPath = true;
                       sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In AUTOEXEC.BAT, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                   }
               }
               if(bIE4) {
                   if((!bJava12)&&(!bNS4)) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/Java/Classes\" in the Windows folder.\n");
                   } else {
                       if(!bModClassPath) {
                           sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In AUTOEXEC.BAT, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                           bModClassPath = true;
                       }
                   }
               }
               if(bHotJava) {
                   if(!bModClassPath) {
                       sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In AUTOEXEC.BAT, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                       bModClassPath = true;
                   }
               }
               if(bJDK11) {
                   if((!bJava12)&&(!bNS4)&&(!bIE4)) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/lib\" in the JDK 1.1 folder.\n");
                   } else {
                       if(!bModClassPath) {
                           sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In AUTOEXEC.BAT, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                           bModClassPath = true;
                       }
                   }
               }
               sb.append((iStep++)+")\tRestart your computer.\n");
               break;
           } case 2: {// Windows NT
               if(bNS4) {
                   if(!bJava12) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/Program/Java/Classes\" in the Netscape folder.\n");
                   } else {
                       bModClassPath = true;
                       sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the \"User Variables\" section of the \"Environment\" tab of the \"System\" control panel, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                   }
               }
               if(bIE4) {
                   if((!bJava12)&&(!bNS4)) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/Java/Classes\" in the Windows folder.\n");
                   } else {
                       if(!bModClassPath) {
                           sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the \"User Variables\" section of the \"Environment\" tab of the \"System\" control panel, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                           bModClassPath = true;
                       }
                   }
               }
               if(bHotJava) {
                   if(!bModClassPath) {
                       sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the \"User Variables\" section of the \"Environment\" tab of the \"System\" control panel, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                       bModClassPath = true;
                   }
               }
               if(bJDK11) {
                   if((!bJava12)&&(!bNS4)&&(!bIE4)) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/lib\" in the JDK 1.1 folder.\n");
                   } else {
                       if(!bModClassPath) {
                           sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the \"User Variables\" section of the \"Environment\" tab of the \"System\" control panel, Put \"SET CLASSPATH=\" if there is no such variable; if there is such a line, put a \";\" before you add the JAR name.\n");
                           bModClassPath = true;
                       }
                   }
               }
               sb.append((iStep++)+")\tRestart your computer.\n");
               break;
           } case 3: {//mac
               if(bMRJ21) {
                   if(!bJava12) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"System Folder:Extensions:MRJ Libraries:MRJ Classes\" in the hard disk.\n");
                   } else {
                       bModClassPath = true;
                       sb.append((iStep++)+")\tYou will need to use JBindery to manually add your JAR to the program OR Move the JAR to the folder \"/MRJ Classes/lib\" in the System Extensions folder.\n");
                   }
               }
               if(bIE4) {
                   sb.append((iStep++)+")\tAdd the JAR to the \"Allowed JAR files\" part of the Java Preferences for IE4.\n");
               }
               break;
           }
           case 4: { //linux
               if(bNS4) {
                   if(!bJava12) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/java/classes\" in the Netscape folder.\n");
                   } else {
                       bModClassPath = true;
                       sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the shell init script, Put \"export CLASSPATH=\" if there is no such variable; if there is such a line, put a \":\" before you add the JAR name.\n");
                   }
               }
               if(bJDK11) {
                   if((!bJava12)&&(!bNS4)&&(!bIE4)) {
                       sb.append((iStep++)+")\tMove the JAR to the folder \"/lib\" in the JDK 1.1 folder.\n");
                   } else {
                       if(!bModClassPath) {
                           sb.append((iStep++)+")\tAdd the FULL path of the JAR to the CLASSPATH environment variable.  (In the shell init script, Put \"export CLASSPATH=\" if there is no such variable; if there is such a line, put a \":\" before you add the JAR name.\n");
                           bModClassPath = true;
                       }
                   }
               }
               sb.append((iStep++)+")\tRestart the shell.\n");
               break;
           }
       }
       return sb.toString();
   }

   private void setPage(int page, boolean advancing) {
       switch(page) {
           case 0: {
               l.setText(welcome);
               p.setContent(l);
               p.getBack().setEnabled(false);
               break;
           } case 1: {
               p.getBack().setEnabled(true);
               if(pPlatform == null) {
                   pPlatform = new Panel();
                   pPlatform.setLayout(new BorderLayout());

                   Panel px = new Panel();
                   px.setLayout(new GridLayout(4,1));

                   px.add(new Checkbox("Windows 95/98", true, cgPlatform));
                   px.add(new Checkbox("Windows NT", false, cgPlatform));
                   px.add(new Checkbox("MacOS", false, cgPlatform));
                   px.add(new Checkbox("Unix", false, cgPlatform));
                   pPlatform.add("South", px);
               }
               l.setText("What kind of computer do you have?");
               pPlatform.add("Center", l);
               p.setContent(pPlatform);
               break;
           } case 2: {
               cbNS4.setState(false);
               cbIE4.setState(false);
               cbHotJava.setState(false);
               cbJDK11.setState(false);
               cbMRJ21.setState(false);
               cbJava12.setState(false);

               cbNS4.setVisible(true);
               cbIE4.setVisible(true);
               cbHotJava.setVisible(true);
               cbJDK11.setVisible(true);
               cbMRJ21.setVisible(true);
               cbJava12.setVisible(true);

               switch(iPlatform){
                   case 1: {cbMRJ21.setVisible(false);break;}
                   case 2: {cbMRJ21.setVisible(false);break;}
                   case 3: {cbNS4.setVisible(false);cbJDK11.setVisible(false);break;}
                   case 4: {cbMRJ21.setVisible(false);cbHotJava.setVisible(false);cbIE4.setVisible(false);break;}
               }

               String x = System.getProperty("java.vendor");
               if(x.equals("Netscape Communications Corporation")) cbNS4.setState(true);
               else if(x.equals("Microsoft Corp.")) cbIE4.setState(true);
               else if(x.equals("Apple Computer, Inc.")) cbMRJ21.setState(true);
               else if(x.equals("Sun Microsystems Inc.")) {cbJDK11.setState(true);cbJava12.setState(true);}

               if(pBrowsers == null) {
                   pBrowsers = new Panel();
                   pBrowsers.setLayout(new BorderLayout());

                   Panel px = new Panel();
                   px.setLayout(new GridLayout(6,1));

                   px.add(cbNS4);
                   px.add(cbIE4);
                   px.add(cbHotJava);
                   px.add(cbJDK11);
                   px.add(cbMRJ21);
                   px.add(cbJava12);
                   pBrowsers.add("South", px);
               }
               l.setText("What kind of web browser do you have?");
               pBrowsers.add("Center", l);
               p.setContent(pBrowsers);
               break;
           } case 3: {
               l.setText(getBrowserConfig());
               p.setContent(l);
           }
       }
   }

   public void onCancel() {
       if(isApp) fm.dispose();
       if(!noExit) System.exit(0);
   }

   public void actionPerformed(ActionEvent e) {
   }

   private final static String welcome =
       "Welcome to the JAR install coach.  It will walk you through the process of installing JARs on your computer.\n"+
       "\n"+
       "You do NOT have to exit all other programs before running this installer.\n"+
       "\n"+
       "Click \"Next\" to continue with the install program.\n"+
       "\n"+
       "\n"+
       "WARNING: Copyright laws and international treaties protect this program.\n"+
       "\n"+
       "Unauthorized reproduction or distribution of this program, or any portion of it, may result in severe civil and criminal penalties and will be prosecuted to the maximum extend possible under the law.";
       //System.getProperty("java.vendor.url")

   public Frame fm;
   public boolean noExit = false;

   public static void main(String args[]) {
       Frame f = new Frame(name);
       f.setBackground(Color.lightGray);
       f.setLayout(new BorderLayout());

       try {
           f.setVisible(true);
       } catch (NoSuchMethodError e) {
           System.err.println("You must have Java 1.1 to install this program!");
           return;
       }

       Dimension s = new Dimension(586, 393);
       f.setSize(s);
       Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       f.setLocation((d.width-s.width)/2, (d.height-s.height)/2);

       InstallJar i = new InstallJar();
       i.isApp = true;
       i.fm = f;
       if(args.length > 0) {
           if(args[0].equals("YouAreNotTheMainWindow")) i.noExit = true;
       }
       f.addWindowListener(i);
       f.add("Center", i);
       i.init();

       f.setTitle(i.name + " Installer");
       f.doLayout();
   }

//   public MainInstaller() {}

   public void init() {
       setBackground(Color.lightGray);
       p = new Wizard(isApp, this);
       setLayout(new BorderLayout());
       add("Center", p);

       sJavaVer = System.getProperty("java.version");
       setPage(0, true);
   }
   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {onCancel();}
}
